const fastify = require('fastify')({
  logger: true
});

fastify.use(require('cors')());
fastify.use(require('dns-prefetch-control')())
fastify.use(require('frameguard')())
fastify.use(require('hide-powered-by')())
fastify.use(require('hsts')())
fastify.use(require('ienoopen')())
fastify.use(require('x-xss-protection')())

fastify.register(require('./awt-plugin'));

fastify.get('/', async (request, reply) => {
  return { hello: 'world' }
});

fastify.get('/', async (request, reply) => {
  return { hello: 'world' }
});

fastify.get('/:number', async (request, reply) => {
  return { number: request.params['number'] }
});

const start = async () => {
  try {
    //await fastify.listen(3000)
    
  fastify.listen(3333, '0.0.0.0', function (err, address) {
  if (err) {
    fastify.log.error(err)
    process.exit(1)
  }
  fastify.log.info(`server listening on ${address}`);
  });
    
    
  } catch (err) {
    fastify.log.error(err)
    process.exit(1)
  }
}
start();